<?php

class PxlCounter_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_counter';
    protected $title = 'BR Counter';
    protected $icon = 'eicon-counter-circle';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/platinumcitylogistics.com.my\/wp-content\/themes\/loraic\/elements\/widgets\/img-layout\/pxl_counter\/layout1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/platinumcitylogistics.com.my\/wp-content\/themes\/loraic\/elements\/widgets\/img-layout\/pxl_counter\/layout2.jpg"}}}]},{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"title","label":"Title","type":"text","label_block":true},{"name":"starting_number","label":"Starting Number","type":"number","default":1},{"name":"ending_number","label":"Ending Number","type":"number","default":100},{"name":"prefix","label":"Number Prefix","type":"text","default":""},{"name":"suffix","label":"Number Suffix","type":"text","default":""},{"name":"thousand_separator_char","label":"Number Separator","type":"select","options":{"":"Default",".":"Dot",",":"Comma"," ":"Space"},"default":""},{"name":"icon_type","label":"Icon Type","type":"select","options":{"icon":"Icon","image":"Image"},"default":"icon"},{"name":"pxl_icon","label":"Icon","type":"icons","fa4compatibility":"icon","condition":{"icon_type":"icon"}},{"name":"icon_image","label":"Icon Image","type":"media","description":"Select image icon.","condition":{"icon_type":"image"}},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justified","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-counter1 .pxl--item-inner":"text-align: {{VALUE}};"},"condition":{"layout":["1"]}}]},{"name":"section_style_general","label":"General","tab":"style","controls":[{"name":"btn_padding","label":"Box Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-inner":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"color","label":"Box Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-inner":"background-color: {{VALUE}};"}},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-inner":"border-style: {{VALUE}} !important;"}},{"name":"border_width","label":"Border Width","type":"dimensions","selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-inner":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;"},"condition":{"border_type!":""},"responsive":true},{"name":"border_color","label":"Border Color","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-inner":"border-color: {{VALUE}} !important;"},"condition":{"border_type!":""}},{"name":"btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-inner":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"style_l1","label":"Style","type":"select","options":{"style-1":"Style 1","style-2":"Style 2"},"default":"style-1"},{"name":"effect","label":"Effect","type":"select","options":{"effect-default":"Default","effect-slide":"Slide"},"default":"effect-default"}]},{"name":"section_style_title","label":"Title","tab":"style","controls":[{"name":"sp_t","label":"Space Top","type":"slider","control_type":"responsive","size_units":["px"],"default":{"size":0},"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-title":"margin-top: {{SIZE}}{{UNIT}} !important;"},"separator":"after"},{"name":"underline_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-title":"border-color: {{VALUE}} !important;"}},{"name":"title_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl--item-title"}]},{"name":"section_style_icon","label":"Icon","tab":"style","controls":[{"name":"icon_color_type","label":"Color Type","type":"select","options":{"color":"Color","gradient":"Gradient"},"default":"color"},{"name":"box_icon_color","label":"Box Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-item--icon":"background-color: {{VALUE}} !important;","{{WRAPPER}} .pxl-counter .pxl--item-inner:hover":"border-color: {{VALUE}} !important;"}},{"name":"icon_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-item--icon i":"color: {{VALUE}};text-fill-color: {{VALUE}};-webkit-text-fill-color: {{VALUE}};background-image: none;"},"condition":{"icon_color_type":["color"]}},{"name":"icon_color_from","label":"Color - From","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-counter .pxl-item--icon":"--gradient-color-from: {{VALUE}};"},"condition":{"icon_color_type":["gradient"]}},{"name":"icon_color_to","label":"Color - To","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-counter .pxl-item--icon":"--gradient-color-to: {{VALUE}};"},"condition":{"icon_color_type":["gradient"]}},{"name":"icon_font_size","label":"Icon Font Size","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-item--icon i":"font-size: {{SIZE}}{{UNIT}};"},"condition":{"icon_type":"icon"}},{"name":"icon_space_top","label":"Top Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-item--icon":"padding-top: {{SIZE}}{{UNIT}};"}},{"name":"icon_space_bottom","label":"Bottom Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-item--icon":"margin-bottom: {{SIZE}}{{UNIT}};"},"separator":"after"}]},{"name":"section_number","label":"Number","tab":"style","controls":[{"name":"nb_stroke_width","label":"Stroke Width","type":"slider","control_type":"responsive","size_units":["px"],"default":{"size":0},"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-suffix, {{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-prefix":"-moz-webkit-text-stroke: {{SIZE}}{{UNIT}} black; -webkit-text-stroke: {{SIZE}}{{UNIT}} black;","{{WRAPPER}} .pxl-counter .pxl--counter-number":"-moz-webkit-text-stroke: {{SIZE}}{{UNIT}} black; -webkit-text-stroke: {{SIZE}}{{UNIT}} black;"},"separator":"after"},{"name":"stroke_color","label":"Text Stroke Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-suffix, {{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-prefix":"-webkit-text-stroke-color: {{VALUE}} !important; -moz-webkit-text-stroke-color: {{VALUE}} !important;","{{WRAPPER}} .pxl-counter .pxl--counter-number":"-webkit-text-stroke-color: {{VALUE}} !important; -moz-webkit-text-stroke-color: {{VALUE}} !important;"}},{"name":"number_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl--counter-number"},{"name":"number_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-number":"color: {{VALUE}};"}},{"name":"prefix_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-suffix, {{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-prefix"},{"name":"prefix_suffix_color","label":"Prefix\/Suffix Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-suffix, {{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-prefix":"color: {{VALUE}};"}},{"name":"prefix_space_bottom","label":"Prefix Spacer Top","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-suffix, {{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-prefix":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"duration","label":"Animation Duration","type":"number","default":2000,"min":100,"step":100},{"name":"number_space_top","label":"Top Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-number":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"number_space_bottom","label":"Bottom Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-number":"margin-bottom: {{SIZE}}{{UNIT}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewIn","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'elementor-waypoints','jquery-numerator','pxl-counter','pxl-counter-slide','loraic-counter' );
}